/*
 * Decompiled with CFR 0.152.
 */
package net.creep3rcrafter.mysticpotions.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.creep3rcrafter.mysticpotions.utils.ItemDamage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Utils {
    public static void lightning(LivingEntity livingEntity, ServerLevel serverLevel, int amplifier) {
        Utils.lightning(livingEntity, serverLevel);
        for (int i = 0; i < amplifier; ++i) {
            Random random = new Random();
            BlockPos entityPos = livingEntity.m_20183_();
            BlockPos blockPos = entityPos.m_7918_(random.nextInt(amplifier) - amplifier / 2, random.nextInt(amplifier) - amplifier / 2, random.nextInt(amplifier) - amplifier / 2);
            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
            lightningbolt.m_20879_(livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null);
            serverLevel.m_7967_((Entity)lightningbolt);
        }
    }

    public static void lightning(LivingEntity livingEntity, ServerLevel serverLevel) {
        BlockPos entityPos = livingEntity.m_20183_();
        LightningBolt LightningBolt2 = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
        LightningBolt2.m_20219_(Vec3.m_82539_((Vec3i)entityPos));
        LightningBolt2.m_20879_(livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null);
        serverLevel.m_7967_((Entity)LightningBolt2);
    }

    public static void explode(Level level, BlockPos blockPos) {
        Utils.explode(level, blockPos, 4.0f);
    }

    public static void explode(Level level, BlockPos blockPos, float radius) {
        Utils.explode(level, blockPos, radius, false);
    }

    public static void explode(Level level, BlockPos blockPos, float radius, boolean fire) {
        level.m_255391_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), radius, fire, Level.ExplosionInteraction.MOB);
    }

    public static void explode(ServerLevel level, BlockPos blockPos) {
        Utils.explode(level, blockPos, 4.0f);
    }

    public static void explode(ServerLevel level, BlockPos blockPos, float radius) {
        Utils.explode(level, blockPos, radius, false);
    }

    public static void explode(ServerLevel level, BlockPos blockPos, float radius, boolean fire) {
        level.m_255391_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), radius, fire, Level.ExplosionInteraction.MOB);
    }

    public static int cropAgeToIndex(int age) {
        if (age > 6) {
            return 3;
        }
        if (age > 3) {
            return 2;
        }
        if (age > 1) {
            return 1;
        }
        return 0;
    }

    public static void dropXP(ServerLevel level, BlockPos blockPos) {
        int j;
        for (int i = 3 + level.f_46441_.m_188503_(5) + level.f_46441_.m_188503_(5); i > 0; i -= j) {
            j = ExperienceOrb.m_20782_((int)i);
            level.m_7967_((Entity)new ExperienceOrb((Level)level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), j));
        }
    }

    public static void damageItem(LivingEntity livingEntity, EquipmentSlot equipmentSlot, int amplifier, Random random) {
        int chance;
        if (livingEntity.m_6844_(equipmentSlot).m_41763_() && (chance = random.nextInt(10)) >= 5) {
            Item item = livingEntity.m_6844_(equipmentSlot).m_41720_();
            if (ItemDamage.getItemDamageType(item) == ItemDamage.ItemDamageType.IRON) {
                livingEntity.m_6844_(equipmentSlot).m_41622_(ItemDamage.ItemDamageType.IRON.damage / 2 * amplifier, livingEntity, source -> source.m_21166_(equipmentSlot));
            }
            if (ItemDamage.getItemDamageType(item) == ItemDamage.ItemDamageType.NETHERITE) {
                livingEntity.m_6844_(equipmentSlot).m_41622_(ItemDamage.ItemDamageType.NETHERITE.damage / 2 * amplifier, livingEntity, source -> source.m_21166_(equipmentSlot));
            }
        }
    }

    public static void damageItem(LivingEntity livingEntity, EquipmentSlot equipmentSlot, int damage) {
        if (livingEntity.m_6844_(equipmentSlot).m_41763_()) {
            livingEntity.m_6844_(equipmentSlot).m_41622_(damage, livingEntity, source -> source.m_21166_(equipmentSlot));
        }
    }

    public static void damageItem(LivingEntity livingEntity, ItemStack itemStack, int damage) {
        if (itemStack.m_41763_()) {
            itemStack.m_41622_(damage, livingEntity, source -> source.m_21166_(EquipmentSlot.CHEST));
        }
    }

    public static <C extends Container, T extends Recipe<C>> List<Item> recipesContainsItems(MinecraftServer server, RecipeType<T> recipeType, List<Item> containsList) {
        ArrayList results = new ArrayList();
        server.m_129894_().m_44013_(recipeType).forEach(recipe -> recipe.m_7527_().forEach(ingredient -> {
            for (Item item : containsList) {
                if (!ingredient.test(new ItemStack((ItemLike)item))) continue;
                results.add(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_());
            }
        }));
        return new ArrayList<Item>(new HashSet(results));
    }

    public int getDistanceToEntity(LivingEntity livingEntity, BlockPos pos) {
        double deltaX = livingEntity.m_20185_() - (double)pos.m_123341_();
        double deltaY = livingEntity.m_20186_() - (double)pos.m_123342_();
        double deltaZ = livingEntity.m_20189_() - (double)pos.m_123343_();
        return (int)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public List<BlockPos> getNearbyBlocks(LivingEntity livingEntity, int radius) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = livingEntity.m_20183_().m_123341_() - radius; x <= livingEntity.m_20183_().m_123341_() + radius; ++x) {
            for (int y = livingEntity.m_20183_().m_123342_() - radius; y <= livingEntity.m_20183_().m_123342_() + radius; ++y) {
                for (int z = livingEntity.m_20183_().m_123343_() - radius; z <= livingEntity.m_20183_().m_123343_() + radius; ++z) {
                    blockPositions.add(new BlockPos(x, y, z));
                }
            }
        }
        return blockPositions;
    }
}

