/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.world;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class BonfireTeleporter
implements ITeleporter {
    BlockPos pos;

    public BonfireTeleporter(BlockPos pos) {
        this.pos = pos;
    }

    public static Vec3 attemptToPlaceNextToBonfire(BlockPos bonfirePos, Level world) {
        Vec3 centre = new Vec3((double)bonfirePos.m_123341_() + 0.5, (double)bonfirePos.m_123342_() + 0.5, (double)bonfirePos.m_123343_() + 0.5);
        for (int i = 0; i <= 3; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            BlockPos newPos = bonfirePos.m_121945_(dir);
            BlockState state = world.m_8055_(new BlockPos((Vec3i)newPos));
            if (!state.m_60734_().m_48673_(state) || world.m_8055_(newPos.m_7495_()).m_247087_()) continue;
            return new Vec3((double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() + 0.5, (double)newPos.m_123343_() + 0.5);
        }
        return centre;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)entity;
            playerMP.m_20334_(0.0, 0.0, 0.0);
            Vec3 destination = BonfireTeleporter.attemptToPlaceNextToBonfire(this.pos, (Level)destWorld);
            playerMP.f_8906_.m_9774_(destination.f_82479_, destination.f_82480_, destination.f_82481_, playerMP.m_146908_(), playerMP.m_146909_());
        }
        return repositionEntity.apply(false);
    }

    public static void travelToBonfire(ServerPlayer player, BlockPos destination, ResourceKey<Level> dimension) {
        BonfireTeleporter tp = new BonfireTeleporter(destination);
        ServerLevel destinationWorld = (ServerLevel)player.m_9236_();
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_9236_().m_5594_(null, destination, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.m_9236_().m_46472_().m_135782_().equals((Object)dimension.m_135782_())) {
            destinationWorld = player.m_9236_().m_7654_().m_129880_(dimension);
            player.changeDimension(destinationWorld, (ITeleporter)tp);
        }
        tp.placeEntity((Entity)player, (ServerLevel)player.m_9236_(), destinationWorld, 0.0f, portal -> player);
    }
}

