/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets.server;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.data.EstusHandler;
import wehavecookies56.bonfires.packets.Packet;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;
import wehavecookies56.bonfires.world.BonfireTeleporter;

public class Travel
extends Packet<Travel> {
    private int x;
    private int y;
    private int z;
    private ResourceKey<Level> dim;

    public Travel(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public Travel(Bonfire bonfire) {
        this.x = bonfire.getPos().m_123341_();
        this.y = bonfire.getPos().m_123342_();
        this.z = bonfire.getPos().m_123343_();
        this.dim = bonfire.getDimension();
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buffer.m_130277_()));
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.m_130070_(this.dim.m_135782_().toString());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        BonfireTileEntity te = (BonfireTileEntity)player.m_9236_().m_7702_(pos);
        BonfireTeleporter.travelToBonfire(player, pos, this.dim);
        if (!BonfiresConfig.Common.disableBonfireRespawn) {
            player.m_9158_(this.dim, pos, player.m_146908_(), false, true);
        }
        EstusHandler.getHandler((Player)player).setLastRested(te.getID());
    }
}

