/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets.server;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.packets.Packet;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.packets.client.SendBonfiresToClient;
import wehavecookies56.bonfires.packets.client.SyncSaveData;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;

public class RequestDimensionsFromServer
extends Packet<RequestDimensionsFromServer> {
    public RequestDimensionsFromServer(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public RequestDimensionsFromServer() {
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        BonfireHandler.IBonfireHandler handler = BonfireHandler.getServerHandler(player.m_20194_());
        ArrayList<UUID> invalidBonfires = new ArrayList<UUID>();
        for (Bonfire bonfire : handler.getRegistry().getBonfires().values()) {
            for (ServerLevel level : player.m_20194_().m_129785_()) {
                if (!level.m_46472_().equals(bonfire.getDimension())) continue;
                BlockEntity blockEntity = level.m_7702_(bonfire.getPos());
                if (blockEntity instanceof BonfireTileEntity) {
                    BonfireTileEntity te = (BonfireTileEntity)blockEntity;
                    if (te.getID().equals(bonfire.getId())) continue;
                    invalidBonfires.add(bonfire.getId());
                    continue;
                }
                invalidBonfires.add(bonfire.getId());
            }
        }
        invalidBonfires.forEach(handler::removeBonfire);
        PacketHandler.sendTo(new SyncSaveData(BonfireHandler.getServerHandler(player.f_8924_).getRegistry().getBonfires()), player);
        if (BonfiresConfig.Common.bonfireDiscoveryMode) {
            PacketHandler.sendTo(new SendBonfiresToClient(player), player);
        } else {
            PacketHandler.sendTo(new SendBonfiresToClient(), player);
        }
    }
}

