/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;
import wehavecookies56.bonfires.client.ClientPacketHandler;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.packets.Packet;

public class SendBonfiresToClient
extends Packet<SendBonfiresToClient> {
    public List<ResourceKey<Level>> dimensions;
    public BonfireRegistry registry;
    public Map<UUID, String> ownerNames;

    public SendBonfiresToClient(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public SendBonfiresToClient() {
        this.dimensions = new ArrayList<ResourceKey<Level>>(ServerLifecycleHooks.getCurrentServer().m_129784_());
        this.registry = BonfireHandler.getServerHandler(ServerLifecycleHooks.getCurrentServer()).getRegistry();
        this.ownerNames = BonfireRegistry.getOwnerNames(ServerLifecycleHooks.getCurrentServer());
    }

    public SendBonfiresToClient(ServerPlayer player) {
        this.dimensions = new ArrayList<ResourceKey<Level>>(ServerLifecycleHooks.getCurrentServer().m_129784_());
        this.registry = BonfireHandler.getServerHandler(ServerLifecycleHooks.getCurrentServer()).getRegistry().getFilteredRegistry(DiscoveryHandler.getHandler((Player)player).getDiscovered().keySet().stream().toList());
        this.ownerNames = BonfireRegistry.getOwnerNames(ServerLifecycleHooks.getCurrentServer());
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.registry = new BonfireRegistry();
        this.registry.readFromNBT(buffer.m_130260_(), this.registry.getBonfires());
        this.dimensions = new ArrayList<ResourceKey<Level>>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.dimensions.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_()));
        }
        CompoundTag owners = buffer.m_130260_();
        this.ownerNames = new HashMap<UUID, String>();
        owners.m_128431_().forEach(s -> this.ownerNames.put(UUID.fromString(s), owners.m_128461_(s)));
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.registry.writeToNBT(new CompoundTag(), this.registry.getBonfires()));
        buffer.m_130130_(this.dimensions.size());
        for (int i = 0; i < this.dimensions.size(); ++i) {
            buffer.m_130085_(this.dimensions.get(i).m_135782_());
        }
        CompoundTag owners = new CompoundTag();
        this.ownerNames.forEach((uuid, s) -> owners.m_128359_(uuid.toString(), s));
        buffer.m_130079_(owners);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientPacketHandler.setBonfiresFromServer(this));
    }
}

