/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import wehavecookies56.bonfires.packets.Packet;
import wehavecookies56.bonfires.packets.client.DeleteScreenshot;
import wehavecookies56.bonfires.packets.client.DisplayTitle;
import wehavecookies56.bonfires.packets.client.OpenBonfireGUI;
import wehavecookies56.bonfires.packets.client.OpenCreateScreen;
import wehavecookies56.bonfires.packets.client.QueueBonfireScreenshot;
import wehavecookies56.bonfires.packets.client.SendBonfiresToClient;
import wehavecookies56.bonfires.packets.client.SyncBonfire;
import wehavecookies56.bonfires.packets.client.SyncDiscoveryData;
import wehavecookies56.bonfires.packets.client.SyncEstusData;
import wehavecookies56.bonfires.packets.client.SyncSaveData;
import wehavecookies56.bonfires.packets.server.LightBonfire;
import wehavecookies56.bonfires.packets.server.ReinforceItem;
import wehavecookies56.bonfires.packets.server.RequestDimensionsFromServer;
import wehavecookies56.bonfires.packets.server.Travel;

public class PacketHandler {
    private static byte packetId = 0;
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("bonfires", "main_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);

    public static void registerPackets() {
        PacketHandler.registerMessage(OpenBonfireGUI.class, OpenBonfireGUI::encode, OpenBonfireGUI::new, Packet::handle);
        PacketHandler.registerMessage(SyncBonfire.class, SyncBonfire::encode, SyncBonfire::new, Packet::handle);
        PacketHandler.registerMessage(SyncSaveData.class, SyncSaveData::encode, SyncSaveData::new, Packet::handle);
        PacketHandler.registerMessage(SyncDiscoveryData.class, SyncDiscoveryData::encode, SyncDiscoveryData::new, Packet::handle);
        PacketHandler.registerMessage(SendBonfiresToClient.class, SendBonfiresToClient::encode, SendBonfiresToClient::new, Packet::handle);
        PacketHandler.registerMessage(OpenCreateScreen.class, OpenCreateScreen::encode, OpenCreateScreen::new, Packet::handle);
        PacketHandler.registerMessage(DisplayTitle.class, DisplayTitle::encode, DisplayTitle::new, Packet::handle);
        PacketHandler.registerMessage(SyncEstusData.class, SyncEstusData::encode, SyncEstusData::new, Packet::handle);
        PacketHandler.registerMessage(QueueBonfireScreenshot.class, QueueBonfireScreenshot::encode, QueueBonfireScreenshot::new, Packet::handle);
        PacketHandler.registerMessage(DeleteScreenshot.class, DeleteScreenshot::encode, DeleteScreenshot::new, Packet::handle);
        PacketHandler.registerMessage(LightBonfire.class, LightBonfire::encode, LightBonfire::new, Packet::handle);
        PacketHandler.registerMessage(ReinforceItem.class, ReinforceItem::encode, ReinforceItem::new, Packet::handle);
        PacketHandler.registerMessage(Travel.class, Travel::encode, Travel::new, Packet::handle);
        PacketHandler.registerMessage(RequestDimensionsFromServer.class, RequestDimensionsFromServer::encode, RequestDimensionsFromServer::new, Packet::handle);
    }

    private static <T extends Packet<T>> void registerMessage(Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encode, Function<FriendlyByteBuf, T> decode, BiConsumer<T, Supplier<NetworkEvent.Context>> handler) {
        byte by = packetId;
        packetId = (byte)(by + 1);
        HANDLER.registerMessage((int)by, clazz, Packet::encode, decode, handler);
    }

    public static void sendTo(Packet<?> packet, ServerPlayer player) {
        HANDLER.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static void sendToAll(Packet<?> packet) {
        HANDLER.send(PacketDistributor.ALL.noArg(), packet);
    }

    public static void sendToServer(Packet<?> packet) {
        HANDLER.sendToServer(packet);
    }

    public static void sendToAllAround(Packet<?> packet, double x, double y, double z, double range, ResourceKey<Level> dimension) {
        HANDLER.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)x, (double)y, (double)z, (double)range, dimension)), packet);
    }
}

