/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.data;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EstusHandler {
    public static final Capability<IEstusHandler> CAPABILITY_ESTUS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEstusHandler>(){});

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EstusHandler());
    }

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent event) {
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("bonfires", "estus"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        IEstusHandler original = EstusHandler.getHandler(event.getOriginal());
        IEstusHandler clone = EstusHandler.getHandler(event.getEntity());
        clone.setUses(original.uses());
        clone.setLastRested(original.lastRested());
        event.getOriginal().invalidateCaps();
    }

    public static IEstusHandler getHandler(Player player) {
        LazyOptional estusHandler = player.getCapability(CAPABILITY_ESTUS, null);
        return (IEstusHandler)estusHandler.orElse(null);
    }

    public static class Provider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        IEstusHandler instance = new Default();

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY_ESTUS.orEmpty(cap, LazyOptional.of(() -> this.instance));
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }

    public static interface IEstusHandler
    extends INBTSerializable<CompoundTag> {
        public UUID lastRested();

        public void setLastRested(UUID var1);

        public int uses();

        public void setUses(int var1);
    }

    public static class Default
    implements IEstusHandler {
        private int uses = 3;
        private UUID bonfire;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("uses", this.uses());
            if (this.lastRested() != null) {
                tag.m_128362_("lastRested", this.lastRested());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.setUses(tag.m_128451_("uses"));
            if (tag.m_128441_("lastRested")) {
                this.setLastRested(tag.m_128342_("lastRested"));
            }
        }

        @Override
        public UUID lastRested() {
            return this.bonfire;
        }

        @Override
        public void setLastRested(UUID id) {
            this.bonfire = id;
        }

        @Override
        public int uses() {
            return this.uses;
        }

        @Override
        public void setUses(int uses) {
            this.uses = uses;
        }
    }
}

