/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.text.WordUtils;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.LocalStrings;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;
import wehavecookies56.bonfires.client.ScreenshotUtils;
import wehavecookies56.bonfires.client.gui.ReinforceScreen;
import wehavecookies56.bonfires.client.gui.widgets.BonfireButton;
import wehavecookies56.bonfires.client.gui.widgets.BonfireCustomButton;
import wehavecookies56.bonfires.client.gui.widgets.BonfirePageButton;
import wehavecookies56.bonfires.client.gui.widgets.DimensionTabButton;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.packets.server.RequestDimensionsFromServer;
import wehavecookies56.bonfires.packets.server.Travel;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;

public class BonfireScreen
extends Screen {
    private final ResourceLocation MENU = new ResourceLocation("bonfires", "textures/gui/bonfire_menu.png");
    public final ResourceLocation TRAVEL_TEX = new ResourceLocation("bonfires", "textures/gui/travel_menu.png");
    private BonfireCustomButton screenshot;
    private BonfireCustomButton info;
    private Button travel;
    private Button leave;
    private Button reinforce;
    Button back;
    private Button next;
    private Button prev;
    public Map<ResourceKey<Level>, List<List<Bonfire>>> bonfires;
    private List<List<ResourceKey<Level>>> pages;
    private int currentPage = 0;
    public int bonfirePage = 0;
    private final BonfireTileEntity bonfire;
    private boolean travelOpen;
    private final int TRAVEL = 0;
    private final int LEAVE = 1;
    private final int REINFORCE = 20;
    public final int BACK = 2;
    private final int NEXT = 3;
    private final int PREV = 4;
    private final int TAB1 = 5;
    private final int TAB2 = 6;
    private final int TAB3 = 7;
    private final int TAB4 = 8;
    private final int TAB5 = 9;
    private final int TAB6 = 10;
    public final int BONFIRE1 = 11;
    private final int BONFIRE2 = 12;
    private final int BONFIRE3 = 13;
    private final int BONFIRE4 = 14;
    private final int BONFIRE5 = 15;
    private final int BONFIRE6 = 16;
    private final int BONFIRE7 = 17;
    private final int BONFIRE_NEXT = 18;
    private final int BONFIRE_PREV = 19;
    private final int SCREENSHOT = 21;
    private final int INFO = 22;
    public int dimTabSelected = 5;
    public int bonfireSelected = 0;
    public Bonfire selectedInstance;
    public DimensionTabButton[] tabs;
    private BonfireButton[] bonfireButtons;
    private BonfirePageButton bonfire_next;
    private BonfirePageButton bonfire_prev;
    private final int tex_height = 166;
    private final int travel_width = 195;
    public final int travel_height = 136;
    public BonfireRegistry registry;
    public List<ResourceKey<Level>> dimensions;
    public Map<UUID, String> ownerNames;
    public final boolean canReinforce;
    Screenshot screenshotImage;
    boolean showInfo = true;
    boolean noScreenshot = false;

    public BonfireScreen(BonfireTileEntity bonfire, Map<UUID, String> ownerNames, List<ResourceKey<Level>> dimensions, BonfireRegistry registry, boolean canReinforce) {
        super((Component)Component.m_237119_());
        this.bonfire = bonfire;
        this.ownerNames = ownerNames;
        this.registry = registry;
        this.f_96541_ = Minecraft.m_91087_();
        this.dimensions = dimensions.stream().sorted((o1, o2) -> {
            if (o1.equals((Object)Level.f_46428_)) {
                return -1;
            }
            return 0;
        }).sorted((o1, o2) -> {
            if (o1.equals((Object)Level.f_46429_)) {
                if (o2.equals((Object)Level.f_46428_)) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }).sorted((o1, o2) -> {
            if (o1.equals((Object)Level.f_46430_)) {
                if (o2.equals((Object)Level.f_46429_)) {
                    return 1;
                }
                if (o2.equals((Object)Level.f_46428_)) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }).toList();
        this.canReinforce = canReinforce;
        if (BonfiresConfig.Client.renderScreenshotsInGui) {
            this.screenshotImage = new Screenshot(Minecraft.m_91087_().f_90987_, new ResourceLocation("bonfires", bonfire.getID().toString()));
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 1) {
            Minecraft.m_91087_().m_91152_((Screen)new BonfireScreen(this.bonfire, this.ownerNames, this.dimensions, this.registry, this.canReinforce));
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Font fr, String text, int x, int y, int color) {
        float f = (float)x - (float)fr.m_92895_(text) / 2.0f;
        float f2 = y;
        Objects.requireNonNull(fr);
        guiGraphics.drawString(fr, text, f, f2 - 9.0f / 2.0f, color, false);
    }

    private Map<ResourceKey<Level>, List<List<Bonfire>>> createSeries(ResourceKey<Level> dimension) {
        List<Bonfire> bonfires = BonfireRegistry.sortBonfiresByTime(this.registry.getPrivateBonfiresByOwnerAndPublicPerDimension(Minecraft.m_91087_().f_91074_.m_20148_(), dimension.m_135782_()));
        bonfires.sort((o1, o2) -> {
            if (o1.getId().equals(this.bonfire.getID())) {
                return -1;
            }
            return 0;
        });
        if (!bonfires.isEmpty()) {
            ArrayList<List<Bonfire>> book = new ArrayList<List<Bonfire>>();
            int plus = 1;
            if (bonfires.size() % 7 == 0) {
                plus = 0;
            }
            for (int i = 0; i < bonfires.size() / 7 + plus; ++i) {
                int start = i * 7;
                if (bonfires.size() < 7) {
                    start = 0;
                }
                List<Bonfire> page = start + 7 > bonfires.size() ? bonfires.subList(start, bonfires.size()) : bonfires.subList(start, start + 7);
                book.add(page);
            }
            HashMap<ResourceKey<Level>, List<List<Bonfire>>> series = new HashMap<ResourceKey<Level>, List<List<Bonfire>>>();
            series.put(dimension, book);
            return series;
        }
        return null;
    }

    public void m_86600_() {
        if (this.bonfire.m_58901_()) {
            this.m_7379_();
        }
        Vec3i vec3i = new Vec3i((int)this.f_96541_.f_91074_.m_20182_().f_82479_, (int)this.f_96541_.f_91074_.m_20182_().f_82480_, (int)this.f_96541_.f_91074_.m_20182_().f_82481_);
        if ((double)this.bonfire.m_58899_().m_123333_(vec3i) > this.f_96541_.f_91074_.getBlockReach() + 3.0) {
            this.m_7379_();
        }
    }

    public void m_7379_() {
        if (this.screenshotImage != null) {
            this.screenshotImage.close();
        }
        super.m_7379_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!ScreenshotUtils.isTakingScreenshot()) {
            this.m_280273_(guiGraphics);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            Font font = Minecraft.m_91087_().f_91062_;
            if (this.travelOpen) {
                String formattedName;
                this.drawTravelMenu(guiGraphics, mouseX, mouseY, partialTicks);
                if (I18n.m_118936_((String)LocalStrings.getDimensionKey(this.tabs[this.dimTabSelected - 5].getDimension()))) {
                    String dimName = this.tabs[this.dimTabSelected - 5].getDimension().m_135782_().m_135815_().replaceAll("_", " ");
                    formattedName = WordUtils.capitalizeFully((String)dimName);
                } else {
                    formattedName = I18n.m_118938_((String)LocalStrings.getDimensionKey(this.tabs[this.dimTabSelected - 5].getDimension()), (Object[])new Object[0]);
                }
                guiGraphics.m_280056_(font, formattedName + " (" + String.valueOf(this.tabs[this.dimTabSelected - 5].getDimension().m_135782_()) + ")", (int)((float)this.f_96543_ / 2.0f - 100.0f), (int)((float)this.f_96544_ / 2.0f - 62.0f), 0x121212, false);
                if (this.bonfireSelected >= 11) {
                    this.drawSelectedBonfire(guiGraphics, mouseX, mouseY, partialTicks);
                    super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                } else {
                    super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                }
                if (this.selectedInstance != null) {
                    int nameX = this.f_96543_ / 2 - 10 + 12;
                    int nameY = this.f_96544_ / 2 - 45;
                    int nameEndX = nameX + font.m_92895_(this.selectedInstance.getName());
                    Objects.requireNonNull(font);
                    int nameEndY = nameY + 9;
                    if (mouseX >= nameX && mouseX <= nameEndX && mouseY >= nameY && mouseY <= nameEndY) {
                        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                        lines.add(Component.m_237115_((String)("ID: " + String.valueOf(this.selectedInstance.getId()))).m_7532_());
                        lines.add(Component.m_237115_((String)("TIME: " + this.selectedInstance.getTimeCreated().toString())).m_7532_());
                        guiGraphics.m_280245_(font, lines, mouseX, mouseY);
                    }
                }
                for (DimensionTabButton currentTab : this.tabs) {
                    if (!currentTab.f_93624_) continue;
                    if (I18n.m_118936_((String)LocalStrings.getDimensionKey(currentTab.getDimension()))) {
                        String dimName = currentTab.getDimension().m_135782_().m_135815_().replaceAll("_", " ");
                        formattedName = WordUtils.capitalizeFully((String)dimName);
                    } else {
                        formattedName = I18n.m_118938_((String)LocalStrings.getDimensionKey(currentTab.getDimension()), (Object[])new Object[0]);
                    }
                    if (mouseX < currentTab.m_252754_() || mouseX > currentTab.m_252754_() + currentTab.m_5711_() || mouseY < currentTab.m_252907_() || mouseY > currentTab.m_252907_() + currentTab.m_93694_()) continue;
                    guiGraphics.m_280557_(font, (Component)Component.m_237115_((String)(formattedName + " (" + String.valueOf(currentTab.getDimension().m_135782_()) + ")")), mouseX, mouseY);
                }
                Object pages = "0/0";
                if (this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()) != null) {
                    pages = this.bonfirePage + 1 + "/" + this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).size();
                }
                int xZero = this.f_96543_ / 2 - 97 + 16;
                int yZero = this.f_96544_ / 2 - 68 + 128 - 17;
                int n = xZero + 27 - font.m_92895_((String)pages) / 2;
                Objects.requireNonNull(font);
                guiGraphics.m_280488_(font, (String)pages, n, yZero + 7 - 9 / 2, 0xFFFFFF);
            } else {
                int tex_width = 90;
                guiGraphics.m_280218_(this.MENU, this.f_96543_ / 4 - tex_width / 2, this.f_96544_ / 2 - 83, 0, 0, tex_width, 166);
                super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                String name = "";
                Bonfire currentBonfire = this.registry.getBonfire(this.bonfire.getID());
                if (currentBonfire != null) {
                    name = currentBonfire.getName();
                    if (!currentBonfire.isPublic()) {
                        this.drawCenteredStringNoShadow(guiGraphics, font, Component.m_237115_((String)"text.bonfires.private").getString(), this.f_96543_ / 4, this.f_96544_ / 2 - 83 + 20, new Color(255, 255, 255).hashCode());
                    }
                }
                this.drawCenteredStringNoShadow(guiGraphics, font, name, this.f_96543_ / 4, this.f_96544_ / 2 - 83 + 10, new Color(255, 255, 255).hashCode());
                this.drawCenteredStringNoShadow(guiGraphics, font, this.ownerNames.get(currentBonfire.getOwner()), this.f_96543_ / 4, this.f_96544_ / 2 - 83 + 166 - 10, new Color(255, 255, 255).hashCode());
            }
        }
    }

    public Bonfire getSelectedBonfire() {
        if (this.bonfireSelected >= 11 && this.bonfires != null && this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()) != null) {
            return this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).get(this.bonfirePage).get(this.bonfireSelected - 11);
        }
        return null;
    }

    private void drawSelectedBonfire(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.selectedInstance != null) {
            int nameX = this.f_96543_ / 2 - 10 + 12;
            int nameY = this.f_96544_ / 2 - 45;
            if (BonfiresConfig.Client.renderScreenshotsInGui && this.screenshotImage != null && this.screenshotImage.textureLocation() != null && !this.noScreenshot) {
                guiGraphics.m_280163_(this.screenshotImage.textureLocation(), nameX - 3, nameY - 5, (float)ScreenshotUtils.width / 2.0f, 0.0f, ScreenshotUtils.width, ScreenshotUtils.height, ScreenshotUtils.width * 2, ScreenshotUtils.height);
            }
            if (this.showInfo) {
                Font font = Minecraft.m_91087_().f_91062_;
                guiGraphics.m_280488_(font, this.selectedInstance.getName(), nameX, nameY, new Color(255, 255, 255).hashCode());
                String string = "X:" + this.selectedInstance.getPos().m_123341_() + " Y:" + this.selectedInstance.getPos().m_123342_() + " Z:" + this.selectedInstance.getPos().m_123343_();
                Objects.requireNonNull(font);
                guiGraphics.m_280488_(font, string, nameX, nameY + 9 + 3, new Color(255, 255, 255).hashCode());
                Objects.requireNonNull(font);
                guiGraphics.m_280488_(font, this.ownerNames.get(this.selectedInstance.getOwner()), nameX, nameY + (9 + 3) * 2, new Color(255, 255, 255).hashCode());
            }
        }
    }

    @Nullable
    File getBonfireScreenshot(String bonfireName, UUID bonfireUUID) {
        Path screenshotsDir = Paths.get(Minecraft.m_91087_().f_91069_.getPath(), "bonfires/");
        if (Files.exists(screenshotsDir, new LinkOption[0])) {
            File screenshot = null;
            File[] files = screenshotsDir.toFile().listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    String nameNoInvalid = bonfireName.replaceAll("[\\\\/:*?\"<>|]", "_").toLowerCase();
                    if (!file.isFile() || !file.getName().equals(nameNoInvalid + "_" + bonfireUUID.toString() + ".png")) continue;
                    screenshot = file;
                    break;
                }
            }
            return screenshot;
        }
        return null;
    }

    private void drawTravelMenu(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int trueWidth = 219;
        for (DimensionTabButton tab : this.tabs) {
            tab.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        guiGraphics.m_280218_(this.TRAVEL_TEX, this.f_96543_ / 2 - trueWidth / 2, this.f_96544_ / 2 - 68, 0, 0, trueWidth, 136);
    }

    public void action(int id) {
        this.action(id, false);
    }

    public void action(int id, boolean closesScreen) {
        switch (id) {
            case 21: {
                if (this.selectedInstance == null || !this.bonfire.getID().equals(this.selectedInstance.getId())) break;
                ScreenshotUtils.startScreenshotTimer(this.selectedInstance.getName(), this.selectedInstance.getId());
                break;
            }
            case 22: {
                this.showInfo = !this.showInfo;
                break;
            }
            case 0: {
                String formattedDimName;
                if (!this.travelOpen) {
                    this.travelOpen = true;
                    PacketHandler.sendToServer(new RequestDimensionsFromServer());
                    break;
                }
                if (this.selectedInstance == null) break;
                Minecraft.m_91087_().f_91073_.m_5594_((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                Minecraft.m_91087_().f_91073_.m_5594_((Player)Minecraft.m_91087_().f_91074_, this.selectedInstance.getPos(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                PacketHandler.sendToServer(new Travel(this.selectedInstance));
                if (I18n.m_118936_((String)LocalStrings.getDimensionKey(this.selectedInstance.getDimension()))) {
                    String dimName = this.selectedInstance.getDimension().m_135782_().m_135815_().replaceAll("_", " ");
                    formattedDimName = WordUtils.capitalizeFully((String)dimName);
                } else {
                    formattedDimName = I18n.m_118938_((String)LocalStrings.getDimensionKey(this.selectedInstance.getDimension()), (Object[])new Object[0]);
                }
                Gui gui = Minecraft.m_91087_().f_91065_;
                gui.m_168714_((Component)Component.m_237115_((String)this.selectedInstance.getName()));
                gui.m_168711_((Component)Component.m_237115_((String)formattedDimName));
                gui.m_168684_(10, 20, 10);
                this.m_7379_();
                closesScreen = true;
                break;
            }
            case 1: {
                this.m_7379_();
                break;
            }
            case 3: {
                if (this.currentPage == this.pages.size() - 1) break;
                ++this.currentPage;
                this.dimTabSelected = 5;
                this.bonfireSelected = 0;
                break;
            }
            case 4: {
                if (this.currentPage == 0) break;
                --this.currentPage;
                this.dimTabSelected = 5;
                this.bonfireSelected = 0;
                break;
            }
            case 18: {
                if (this.bonfirePage == this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).size() - 1) break;
                ++this.bonfirePage;
                this.bonfireSelected = 0;
                break;
            }
            case 19: {
                if (this.bonfirePage == 0) break;
                --this.bonfirePage;
                this.bonfireSelected = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.dimTabSelected = id;
                this.bonfireSelected = 0;
                if (this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()) != null && !this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).isEmpty() && !this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).get(0).isEmpty()) {
                    this.bonfireSelected = 11;
                    this.selectedInstance = this.registry.getBonfires().get(this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).get(0).get(0).getId());
                    this.loadBonfireScreenshot();
                }
                this.bonfirePage = 0;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.bonfireSelected = id;
                this.selectedInstance = this.getSelectedBonfire();
                if (!BonfiresConfig.Client.renderScreenshotsInGui) break;
                this.loadBonfireScreenshot();
                break;
            }
            case 20: {
                this.f_96541_.m_91152_((Screen)new ReinforceScreen(this));
            }
        }
        this.updateButtons();
        if (!closesScreen) {
            PacketHandler.sendToServer(new RequestDimensionsFromServer());
        }
    }

    public void loadBonfireScreenshot() {
        if (this.selectedInstance != null) {
            File screenshotFile = this.getBonfireScreenshot(this.selectedInstance.getName(), this.selectedInstance.getId());
            if (screenshotFile != null) {
                try {
                    if (this.screenshotImage != null) {
                        this.screenshotImage.close();
                        this.screenshotImage = new Screenshot(Minecraft.m_91087_().f_90987_, new ResourceLocation("bonfires", this.bonfire.getID().toString()));
                    }
                    this.screenshotImage.upload(NativeImage.m_85058_((InputStream)new FileInputStream(screenshotFile)));
                    this.noScreenshot = false;
                    this.info.f_93624_ = true;
                    this.info.f_93623_ = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.noScreenshot = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateButtons() {
        for (DimensionTabButton dimensionTabButton : this.tabs) {
            dimensionTabButton.f_93624_ = false;
        }
        if (this.travelOpen) {
            void var1_5;
            void var1_3;
            if (this.bonfireSelected >= 11) {
                this.travel.f_93624_ = true;
                if (this.selectedInstance != null) {
                    this.travel.f_93623_ = !this.selectedInstance.getId().equals(this.bonfire.getID());
                }
                this.travel.m_252865_(this.f_96543_ / 2 - 5 + 12);
                this.travel.m_253211_(this.f_96544_ / 2 + 38);
                this.info.f_93624_ = !this.noScreenshot;
                boolean bl = this.info.f_93623_ = !this.noScreenshot;
                if (BonfiresConfig.Client.renderScreenshotsInGui) {
                    if (this.bonfire.getID().equals(this.selectedInstance.getId())) {
                        this.screenshot.f_93624_ = true;
                        this.screenshot.f_93623_ = true;
                        if (this.noScreenshot) {
                            this.screenshot.m_253211_(this.f_96544_ / 2 - 50);
                        } else {
                            this.screenshot.m_253211_(this.f_96544_ / 2 - 36);
                        }
                    } else {
                        this.screenshot.f_93624_ = false;
                        this.screenshot.f_93623_ = false;
                    }
                }
            } else {
                this.travel.f_93624_ = false;
                this.info.f_93624_ = false;
                this.screenshot.f_93624_ = false;
                this.info.f_93623_ = false;
                this.screenshot.f_93623_ = false;
            }
            boolean bl = false;
            while (var1_3 < this.tabs.length) {
                if (var1_3 < this.pages.get(this.currentPage).size()) {
                    this.tabs[var1_3].f_93624_ = true;
                    this.tabs[var1_3].setDimension(this.pages.get(this.currentPage).get((int)var1_3));
                }
                ++var1_3;
            }
            boolean bl2 = false;
            while (var1_5 < this.bonfireButtons.length) {
                if (this.tabs[this.dimTabSelected - 5] != null && this.bonfires != null) {
                    if (this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()) != null) {
                        if (var1_5 < this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).get(this.bonfirePage).size()) {
                            this.bonfireButtons[var1_5].f_93624_ = true;
                            this.bonfireButtons[var1_5].setBonfire(this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).get(this.bonfirePage).get((int)var1_5));
                        } else {
                            this.bonfireButtons[var1_5].f_93624_ = false;
                        }
                    } else {
                        this.bonfireButtons[var1_5].f_93624_ = false;
                    }
                }
                ++var1_5;
            }
            this.reinforce.f_93624_ = false;
            this.leave.f_93624_ = false;
            this.next.f_93624_ = true;
            this.prev.f_93624_ = true;
            this.bonfire_prev.f_93624_ = true;
            this.bonfire_next.f_93624_ = true;
            this.prev.f_93623_ = this.currentPage != 0;
            this.next.f_93623_ = this.currentPage != this.pages.size() - 1;
            this.bonfire_prev.f_93623_ = this.bonfirePage != 0;
            this.bonfire_next.f_93623_ = this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()) != null && this.bonfirePage != this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).size() - 1;
        } else {
            this.bonfire_prev.f_93624_ = false;
            this.bonfire_prev.f_93623_ = false;
            this.bonfire_next.f_93624_ = false;
            this.bonfire_next.f_93623_ = false;
            this.travel.f_93624_ = true;
            this.travel.m_252865_(this.f_96543_ / 4 - 40);
            this.travel.m_253211_(this.f_96544_ / 2 - 83 + 20);
            if (this.registry.getBonfire(this.bonfire.getID()) != null && !this.registry.getBonfire(this.bonfire.getID()).isPublic()) {
                this.travel.m_253211_(this.f_96544_ / 2 - 83 + 30);
                this.reinforce.m_253211_(this.f_96544_ / 2 - 83 + 51);
                this.leave.m_253211_(this.f_96544_ / 2 - 83 + 72);
            }
            this.reinforce.f_93624_ = true;
            this.leave.f_93624_ = true;
            this.next.f_93624_ = false;
            this.prev.f_93624_ = false;
            this.prev.f_93623_ = false;
            this.next.f_93623_ = false;
            this.info.f_93624_ = false;
            this.info.f_93623_ = false;
            this.screenshot.f_93624_ = false;
            this.screenshot.f_93623_ = false;
            for (DimensionTabButton dimensionTabButton : this.tabs) {
                dimensionTabButton.f_93624_ = false;
            }
            for (BonfireButton bonfireButton : this.bonfireButtons) {
                bonfireButton.f_93624_ = false;
            }
        }
        if (!this.canReinforce) {
            this.reinforce.f_93624_ = false;
            this.leave.m_253211_(this.reinforce.m_252907_());
        }
    }

    public boolean m_6913_() {
        return !ScreenshotUtils.isTakingScreenshot();
    }

    protected void m_7856_() {
        int i;
        int i2;
        super.m_7856_();
        this.pages = new ArrayList<List<ResourceKey<Level>>>();
        this.bonfires = new HashMap<ResourceKey<Level>, List<List<Bonfire>>>();
        int selectedX = this.f_96543_ / 2 - 17;
        int selectedY = this.f_96544_ / 2 - 50;
        this.screenshot = new BonfireCustomButton(21, selectedX + 16 + 87, selectedY, BonfireCustomButton.ButtonType.SCREENSHOT, button -> this.action(21));
        this.m_142416_((GuiEventListener)this.screenshot);
        this.info = new BonfireCustomButton(22, selectedX + 16 + 87, selectedY, BonfireCustomButton.ButtonType.INFO, button -> this.action(22));
        this.m_142416_((GuiEventListener)this.info);
        this.travel = Button.m_253074_((Component)Component.m_237115_((String)"button.bonfires.travel"), button -> this.action(0)).m_252794_(this.f_96543_ / 4 - 40, this.f_96544_ / 2 - 83 + 25).m_253046_(80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.travel);
        this.leave = Button.m_253074_((Component)Component.m_237115_((String)"button.bonfires.leave"), button -> this.action(1, true)).m_252794_(this.f_96543_ / 4 - 40, this.f_96544_ / 2 - 83 + 62).m_253046_(80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.leave);
        this.reinforce = Button.m_253074_((Component)Component.m_237115_((String)"button.bonfires.reinforce"), button -> this.action(20, true)).m_252794_(this.f_96543_ / 4 - 40, this.f_96544_ / 2 - 83 + 41).m_253046_(80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.reinforce);
        this.next = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.action(3)).m_252794_(0, 0).m_253046_(20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.next);
        this.prev = Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.action(4)).m_252794_(20, 0).m_253046_(20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prev);
        this.bonfire_next = new BonfirePageButton(this, 18, 0, 0, true);
        this.m_142416_((GuiEventListener)this.bonfire_next);
        this.bonfire_prev = new BonfirePageButton(this, 19, 8, 0, false);
        this.m_142416_((GuiEventListener)this.bonfire_prev);
        this.tabs = new DimensionTabButton[]{new DimensionTabButton(this, 5, 0, 0), new DimensionTabButton(this, 6, 0, 0), new DimensionTabButton(this, 7, 0, 0), new DimensionTabButton(this, 8, 0, 0), new DimensionTabButton(this, 9, 0, 0), new DimensionTabButton(this, 10, 0, 0)};
        this.bonfireButtons = new BonfireButton[]{new BonfireButton(this, 11, 0, 0), new BonfireButton(this, 12, 0, 0), new BonfireButton(this, 13, 0, 0), new BonfireButton(this, 14, 0, 0), new BonfireButton(this, 15, 0, 0), new BonfireButton(this, 16, 0, 0), new BonfireButton(this, 17, 0, 0)};
        for (i2 = 0; i2 < this.tabs.length; ++i2) {
            this.m_142416_((GuiEventListener)this.tabs[i2]);
            int sixTabs = 168;
            int gap = 195 - sixTabs;
            this.tabs[i2].m_252865_(this.f_96543_ / 2 - 97 + i2 * 28 + gap / 2);
            this.tabs[i2].m_253211_(this.f_96544_ / 2 - 97 + 1);
        }
        for (i2 = 0; i2 < this.bonfireButtons.length; ++i2) {
            this.m_142416_((GuiEventListener)this.bonfireButtons[i2]);
            this.bonfireButtons[i2].m_252865_(this.f_96543_ / 2 - 88 - 12);
            this.bonfireButtons[i2].m_253211_(this.f_96544_ / 2 + this.bonfireButtons[i2].m_93694_() * i2 - 50);
        }
        this.prev.m_252865_(this.f_96543_ / 2 - 97 - 8);
        this.prev.m_253211_(this.f_96544_ / 2 - 97 + 6);
        int sixTabs = 168;
        int gap = 195 - sixTabs;
        this.next.m_252865_(this.f_96543_ / 2 - 97 + 168 + gap / 2);
        this.next.m_253211_(this.f_96544_ / 2 - 97 + 6);
        this.bonfire_prev.m_252865_(this.f_96543_ / 2 - 97 + 16);
        this.bonfire_prev.m_253211_(this.f_96544_ / 2 - 68 + 128 - 17);
        this.bonfire_next.m_252865_(this.f_96543_ / 2 - 97 + 63);
        this.bonfire_next.m_253211_(this.f_96544_ / 2 - 68 + 128 - 17);
        this.updateBonfires();
        int plus = 1;
        if (this.dimensions.size() % 6 == 0) {
            plus = 0;
        }
        for (i = 0; i < this.dimensions.size() / 6 + plus; ++i) {
            int start = i * 6;
            if (this.dimensions.size() < 6) {
                start = 0;
            }
            if (start + 6 > this.dimensions.size()) {
                this.pages.add(this.dimensions.subList(start, this.dimensions.size()));
                continue;
            }
            this.pages.add(this.dimensions.subList(start, start + 6));
        }
        for (i = 0; i < this.pages.size(); ++i) {
            for (int j = 0; j < this.pages.get(i).size(); ++j) {
                if (!Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().equals((Object)this.pages.get(i).get(j).m_135782_())) continue;
                this.currentPage = i;
                this.dimTabSelected = j + 5;
            }
        }
        this.bonfireSelected = 11;
        this.selectedInstance = this.registry.getBonfire(this.bonfire.getID());
        this.loadBonfireScreenshot();
        this.updateButtons();
    }

    public void updateDimensionsFromServer(BonfireRegistry registry, List<ResourceKey<Level>> dimensions, Map<UUID, String> ownerNames) {
        this.dimensions = dimensions.stream().sorted((o1, o2) -> {
            if (o1.equals((Object)Level.f_46428_)) {
                return -1;
            }
            return 0;
        }).sorted((o1, o2) -> {
            if (o1.equals((Object)Level.f_46429_)) {
                if (o2.equals((Object)Level.f_46428_)) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }).sorted((o1, o2) -> {
            if (o1.equals((Object)Level.f_46430_)) {
                if (o2.equals((Object)Level.f_46429_)) {
                    return 1;
                }
                if (o2.equals((Object)Level.f_46428_)) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }).toList();
        this.registry = registry;
        this.ownerNames = ownerNames;
        this.updateBonfires();
        this.updateButtons();
    }

    private void updateBonfires() {
        this.bonfires.clear();
        for (ResourceKey<Level> dim : this.dimensions) {
            Map<ResourceKey<Level>, List<List<Bonfire>>> series = this.createSeries(dim);
            if (series == null || series.get(dim) == null) continue;
            this.bonfires.put(dim, series.get(dim));
        }
        if (this.selectedInstance != null && this.bonfireSelected != 0) {
            if (this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()) != null) {
                List<Bonfire> bonfiresInCurrentPage = this.bonfires.get(this.tabs[this.dimTabSelected - 5].getDimension()).get(this.bonfirePage);
                if (bonfiresInCurrentPage.stream().filter(b -> this.selectedInstance.getId().equals(b.getId())).toList().isEmpty()) {
                    this.selectedInstance = null;
                    this.bonfireSelected = 0;
                }
            } else {
                this.selectedInstance = null;
                this.bonfireSelected = 0;
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public static class Screenshot
    implements AutoCloseable {
        private static final ResourceLocation MISSING_LOCATION = null;
        private final TextureManager textureManager;
        private final ResourceLocation textureLocation;
        @Nullable
        private DynamicTexture texture;
        private boolean closed;

        private Screenshot(TextureManager pTextureManager, ResourceLocation pTextureLocation) {
            this.textureManager = pTextureManager;
            this.textureLocation = pTextureLocation;
        }

        public void upload(NativeImage pImage) {
            try {
                this.checkOpen();
                if (this.texture == null) {
                    this.texture = new DynamicTexture(pImage);
                } else {
                    this.texture.m_117988_(pImage);
                    this.texture.m_117985_();
                }
                this.textureManager.m_118495_(this.textureLocation, (AbstractTexture)this.texture);
            }
            catch (Throwable throwable) {
                pImage.close();
                this.clear();
                throw throwable;
            }
        }

        public void clear() {
            this.checkOpen();
            if (this.texture != null) {
                this.textureManager.m_118513_(this.textureLocation);
                this.texture.close();
                this.texture = null;
            }
        }

        public int getHeight() {
            if (this.texture != null) {
                return this.texture.m_117991_().m_85084_();
            }
            return 0;
        }

        public int getWidth() {
            if (this.texture != null) {
                return this.texture.m_117991_().m_84982_();
            }
            return 0;
        }

        public ResourceLocation textureLocation() {
            return this.texture != null ? this.textureLocation : MISSING_LOCATION;
        }

        @Override
        public void close() {
            this.clear();
            this.closed = true;
        }

        private void checkOpen() {
            if (this.closed) {
                throw new IllegalStateException("Icon already closed");
            }
        }
    }
}

