/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.client.gui.BonfireScreen;
import wehavecookies56.bonfires.client.gui.CreateBonfireScreen;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScreenshotUtils {
    private static boolean takingScreenshot = false;
    private static String name;
    private static UUID uuid;
    public static int width;
    public static int height;

    public static boolean isTakingScreenshot() {
        return takingScreenshot;
    }

    public static String getFileNameString(String bonfireName, UUID bonfireUUID) {
        String nameNoInvalid = bonfireName.replaceAll("[\\\\/:*?\"<>|]", "_").toLowerCase();
        return nameNoInvalid + "_" + bonfireUUID.toString() + ".png";
    }

    public static void startScreenshotTimer(String bonfireName, UUID bonfireUUID) {
        name = bonfireName;
        uuid = bonfireUUID;
        takingScreenshot = true;
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void takeScreenshot(String bonfireName, UUID bonfireUUID) {
        Path p = Paths.get(Minecraft.m_91087_().f_91069_.getPath(), "bonfires");
        String fileName = ScreenshotUtils.getFileNameString(bonfireName, bonfireUUID);
        File fileToCreate = new File(p.toFile(), fileName);
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (NativeImage image = Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_());){
            image.m_85056_(fileToCreate);
            Bonfires.LOGGER.info("Saved bonfire screenshot " + fileName);
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null && takingScreenshot) {
            takingScreenshot = false;
            Minecraft.m_91087_().f_91066_.f_92062_ = false;
            ScreenshotUtils.takeScreenshot(name, uuid);
            if (Minecraft.m_91087_().f_91080_ != null) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreateBonfireScreen) {
                    CreateBonfireScreen create = (CreateBonfireScreen)screen;
                    create.m_7379_();
                }
                if ((screen = Minecraft.m_91087_().f_91080_) instanceof BonfireScreen) {
                    BonfireScreen bonfire = (BonfireScreen)screen;
                    bonfire.loadBonfireScreenshot();
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderOverlays(RenderGuiOverlayEvent.Pre event) {
        event.setCanceled(takingScreenshot);
    }

    static {
        width = 103;
        height = 110;
    }
}

