/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="bonfires", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BonfiresConfig {
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    @SubscribeEvent
    public static void configEvent(ModConfigEvent event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            Client.renderTextAboveBonfire = (Boolean)BonfiresConfig.CLIENT.renderTextAboveBonfireConfig.get();
            Client.tabIcons = (List)BonfiresConfig.CLIENT.tabIconsConfig.get();
            Client.renderScreenshotsInGui = (Boolean)BonfiresConfig.CLIENT.renderScreenshotsInGuiConfig.get();
            Client.enableAutomaticScreenshotOnCreation = (Boolean)BonfiresConfig.CLIENT.enableAutomaticScreenshotOnCreationConfig.get();
            Client.deleteScreenshotsOnDestroyed = (Boolean)BonfiresConfig.CLIENT.deleteScreenshotsOnDestroyedConfig.get();
            Client.hiddenDimensions = (List)BonfiresConfig.CLIENT.hiddenDimensionsConfig.get();
            Client.disableBonfireParticles = (Boolean)BonfiresConfig.CLIENT.disableBonfireParticlesConfig.get();
            Client.bonfireAmbientSound = (String)BonfiresConfig.CLIENT.bonfireAmbientSoundConfig.get();
        } else if (event.getConfig().getSpec() == COMMON_SPEC) {
            Common.enableReinforcing = (Boolean)BonfiresConfig.COMMON.enableReinforcingConfig.get();
            Common.enableUBSBonfire = (Boolean)BonfiresConfig.COMMON.enableUBSBonfireConfig.get();
            Common.reinforceBlacklist = (List)BonfiresConfig.COMMON.reinforceBlacklistConfig.get();
            Common.bonfireMonsterCheckRadius = (Double)BonfiresConfig.COMMON.bonfireMonsterCheckRadiusConfig.get();
            Common.repairEquipment = (Boolean)BonfiresConfig.COMMON.repairEquipmentConfig.get();
            Common.bonfireDiscoveryMode = (Boolean)BonfiresConfig.COMMON.bonfireDiscoveryModeConfig.get();
            Common.disableAshDrops = (Boolean)BonfiresConfig.COMMON.disableAshDropsConfig.get();
            Common.disableBonfireRespawn = (Boolean)BonfiresConfig.COMMON.disableBonfireRespawnConfig.get();
        } else if (event.getConfig().getSpec() == SERVER_SPEC) {
            Server.estusFlaskBaseHeal = (Double)BonfiresConfig.SERVER.estusFlaskBaseHealConfig.get();
            Server.estusFlaskHealPerLevel = (Double)BonfiresConfig.SERVER.estusFlaskHealPerLevelConfig.get();
            Server.reinforceDamagePerLevel = (Double)BonfiresConfig.SERVER.reinforceDamagePerLevelConfig.get();
        }
    }

    static {
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)clientPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        Pair commonPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonPair.getRight();
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)serverPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverPair.getRight();
    }

    public static class Client {
        public static boolean renderTextAboveBonfire = true;
        public final ForgeConfigSpec.BooleanValue renderTextAboveBonfireConfig;
        public static List<String> tabIcons = Arrays.asList("minecraft:overworld=minecraft:grass_block", "minecraft:the_nether=minecraft:netherrack", "minecraft:the_end=minecraft:end_stone", "kingdomkeys:dive_to_the_heart=kingdomkeys:mosaic_stained_glass");
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> tabIconsConfig;
        public static boolean renderScreenshotsInGui = true;
        public final ForgeConfigSpec.BooleanValue renderScreenshotsInGuiConfig;
        public static boolean enableAutomaticScreenshotOnCreation = true;
        public final ForgeConfigSpec.BooleanValue enableAutomaticScreenshotOnCreationConfig;
        public static boolean deleteScreenshotsOnDestroyed = true;
        public final ForgeConfigSpec.BooleanValue deleteScreenshotsOnDestroyedConfig;
        public static List<String> hiddenDimensions = new ArrayList<String>();
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> hiddenDimensionsConfig;
        public static boolean disableBonfireParticles = false;
        public final ForgeConfigSpec.BooleanValue disableBonfireParticlesConfig;
        public static String bonfireAmbientSound = SoundEvents.f_11784_.m_11660_().toString();
        public final ForgeConfigSpec.ConfigValue<String> bonfireAmbientSoundConfig;

        public Client(ForgeConfigSpec.Builder builder) {
            this.renderTextAboveBonfireConfig = builder.comment("Whether to Render the name of the Bonfire above the Bonfire, default:true").define("Render Text Above Bonfire", renderTextAboveBonfire);
            this.tabIconsConfig = builder.comment("Set the icons to display for the dimension tabs in the Bonfire GUI, mod:dimensionname=mod:itemname").defineList("Bonfire Dimension Tab Icons", tabIcons, input -> this.validateIcon((String)input));
            this.renderScreenshotsInGuiConfig = builder.comment("Whether to render screenshots of the Bonfires in the Bonfire GUI, default:true").define("Render Screenshots in GUI", renderScreenshotsInGui);
            this.enableAutomaticScreenshotOnCreationConfig = builder.comment("Enables creating a screenshot of a Bonfire when it is created, default:true").define("Enable Automatic Screenshot on Creation", enableAutomaticScreenshotOnCreation);
            this.deleteScreenshotsOnDestroyedConfig = builder.comment("Whether to delete Bonfire screenshots when the Bonfire is destroyed, default:true").define("Delete Screenshots on Destroyed", deleteScreenshotsOnDestroyed);
            this.hiddenDimensionsConfig = builder.comment("List of dimensions to hide from the Bonfire GUI useful if you can't place a bonfire in the dimension, mod:dimensionname").defineList("Hidden Dimensions in GUI", hiddenDimensions, input -> ((String)input).contains(":"));
            this.disableBonfireParticlesConfig = builder.comment("Disable particles from lit Bonfires, default:false").define("Disable Bonfire Particles", disableBonfireParticles);
            this.bonfireAmbientSoundConfig = builder.comment("Sound to use when a Bonfire is lit, set to empty string to disable, default:\"minecraft:block.campfire.crackle\"").define("Bonfire Ambient Sound", (Object)bonfireAmbientSound);
        }

        public boolean validateIcon(String input) {
            if (input.contains("=")) {
                String[] split = input.split("=");
                if (split.length == 2) {
                    return split[0].contains(":") && split[1].contains(":");
                }
                return false;
            }
            return false;
        }
    }

    public static class Common {
        public static boolean enableUBSBonfire = true;
        public final ForgeConfigSpec.BooleanValue enableUBSBonfireConfig;
        public static boolean enableReinforcing = true;
        public final ForgeConfigSpec.BooleanValue enableReinforcingConfig;
        public static List<String> reinforceBlacklist = new ArrayList<String>();
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> reinforceBlacklistConfig;
        public static double bonfireMonsterCheckRadius = 8.0;
        public final ForgeConfigSpec.DoubleValue bonfireMonsterCheckRadiusConfig;
        public static boolean repairEquipment = false;
        public final ForgeConfigSpec.BooleanValue repairEquipmentConfig;
        public static boolean bonfireDiscoveryMode = true;
        public final ForgeConfigSpec.BooleanValue bonfireDiscoveryModeConfig;
        public static boolean disableAshDrops = false;
        public final ForgeConfigSpec.BooleanValue disableAshDropsConfig;
        public static boolean disableBonfireRespawn = false;
        public final ForgeConfigSpec.BooleanValue disableBonfireRespawnConfig;

        public Common(ForgeConfigSpec.Builder builder) {
            this.enableUBSBonfireConfig = builder.comment("Enable undead bone shard drops from blowing up a bonfire, default:true").define("Enable Undead Bone Shard drops", enableUBSBonfire);
            this.enableReinforcingConfig = builder.comment("Enable weapon/tool reinforcing, default:true").define("Enable reinforcing", enableReinforcing);
            this.reinforceBlacklistConfig = builder.worldRestart().comment("Disable specific items from being able to reinforce them").defineList("Reinforce item blacklist", reinforceBlacklist, input -> this.validateBlacklist((String)input));
            this.bonfireMonsterCheckRadiusConfig = builder.comment("The radius to check for Monsters around the Bonfire, set to 0 to disable, default:8.0").defineInRange("Bonfire Monster Check Radius", bonfireMonsterCheckRadius, 0.0, Double.MAX_VALUE);
            this.repairEquipmentConfig = builder.comment("Repair tools and armour when using a Bonfire, default:false").define("Repair equipment", repairEquipment);
            this.bonfireDiscoveryModeConfig = builder.comment("Bonfire menu will only display Bonfires that the player has discovered, default:true").define("Enable Bonfire Discovery Mode", bonfireDiscoveryMode);
            this.disableAshDropsConfig = builder.comment("Disable Ash drops from mobs killed with fire, default:false").define("Disable Ash Drops", disableAshDrops);
            this.disableBonfireRespawnConfig = builder.comment("Disable Bonfires setting your respawn point when using them or travelling to them, default:false").define("Disable Bonfire Respawn", disableBonfireRespawn);
        }

        public boolean validateBlacklist(String input) {
            return input.contains(":");
        }
    }

    public static class Server {
        public static double estusFlaskBaseHeal = 6.0;
        public final ForgeConfigSpec.DoubleValue estusFlaskBaseHealConfig;
        public static double estusFlaskHealPerLevel = 1.0;
        public final ForgeConfigSpec.DoubleValue estusFlaskHealPerLevelConfig;
        public static double reinforceDamagePerLevel = 0.5;
        public final ForgeConfigSpec.DoubleValue reinforceDamagePerLevelConfig;

        public Server(ForgeConfigSpec.Builder builder) {
            this.estusFlaskBaseHealConfig = builder.comment("Set how much the Estus Flask heals by default, 1 = half a heart, default:6").defineInRange("Estus Flask Base Heal", estusFlaskBaseHeal, 0.0, Double.MAX_VALUE);
            this.estusFlaskHealPerLevelConfig = builder.comment("Set the amount to increase Estus Flask healing per level, default:1").defineInRange("Estus Flask Heal Per Level", estusFlaskHealPerLevel, 0.0, Double.MAX_VALUE);
            this.reinforceDamagePerLevelConfig = builder.comment("Set the amount to increase damage for reinforced tools per level, default:0.5").defineInRange("Reinforce Damage Per Level", reinforceDamagePerLevel, 0.0, Double.MAX_VALUE);
        }
    }
}

