/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.PartialBlockDamageManager;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.index.CBCDamageTypes;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.fragment_burst.CBCProjectileBurst;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurst;

public class ShrapnelBurst
extends CBCProjectileBurst {
    public ShrapnelBurst(EntityType<? extends ShrapnelBurst> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void m_8119_() {
        ParticleOptions trailParticle;
        super.m_8119_();
        if (this.m_9236_().f_46443_ && (trailParticle = this.getTrailParticle()) != null) {
            for (ProjectileBurst.SubProjectile subProjectile : this.subProjectiles) {
                this.m_9236_().m_7106_(trailParticle, this.m_20185_() + subProjectile.displacement()[0], this.m_20186_() + subProjectile.displacement()[1], this.m_20189_() + subProjectile.displacement()[2], 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onSubProjectileHitEntity(EntityHitResult result, ProjectileBurst.SubProjectile subProjectile) {
        EntityDamagePropertiesComponent properties = this.getProperties().damage();
        Entity entity = result.m_82443_();
        if (properties == null || properties.ignoresInvulnerability()) {
            entity.f_19802_ = 0;
        }
        float damage = properties == null ? 0.0f : properties.entityDamage();
        entity.m_6469_(this.getDamageSource(), damage);
        if (properties == null || !properties.rendersInvulnerable()) {
            entity.f_19802_ = 0;
        }
    }

    protected void onSubProjectileHitBlock(BlockHitResult result, ProjectileBurst.SubProjectile subProjectile) {
        Level curPom2;
        super.onSubProjectileHitBlock(result, subProjectile);
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_46865_(pos).m_8055_(pos);
        if (!this.m_9236_().f_46443_ && state.m_60800_((BlockGetter)this.m_9236_(), pos) != -1.0f && this.canDestroyBlock(state)) {
            Vec3 curVel = new Vec3(subProjectile.velocity()[0], subProjectile.velocity()[1], subProjectile.velocity()[2]);
            double curPom2 = (double)this.getProperties().ballistics().durabilityMass() * curVel.m_82553_();
            double toughness = BlockArmorPropertiesHandler.getProperties(state).toughness(this.m_9236_(), state, pos, true);
            BlockPos pos1 = pos.m_7949_();
            CreateBigCannons.BLOCK_DAMAGE.damageBlock(pos1, (int)Math.min(curPom2, toughness), state, this.m_9236_(), PartialBlockDamageManager::voidBlock);
        }
        if ((curPom2 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)curPom2;
            BlockParticleOption options = new BlockParticleOption(ParticleTypes.f_123794_, state);
            for (ServerPlayer player : slevel.m_6907_()) {
                if (!(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 1024.0)) continue;
                slevel.m_8624_(player, (ParticleOptions)options, true, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 20, 0.4, 2.0, 0.4, 1.0);
            }
        }
        SoundType type = state.m_60827_();
        this.m_9236_().m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), type.m_56775_(), SoundSource.NEUTRAL, type.m_56773_() * 2.0f, type.m_56774_(), false);
    }

    protected boolean canDestroyBlock(BlockState state) {
        return true;
    }

    @Nullable
    public ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123762_;
    }

    public double getSubProjectileWidth() {
        return 0.8;
    }

    public double getSubProjectileHeight() {
        return 0.8;
    }

    protected DamageSource getDamageSource() {
        return new CannonDamageSource((Holder<DamageType>)CannonDamageSource.getDamageRegistry(this.m_9236_()).m_246971_(CBCDamageTypes.SHRAPNEL), this.getProperties().damage().ignoresEntityArmor());
    }
}

