/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.mixins.common;

import com.google.common.collect.ImmutableList;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.common.entities.mob.lunarians.LunarianWanderingTraderSpawner;
import earth.terrarium.adastra.common.systems.EnvironmentEffects;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Shadow
    @Mutable
    @Final
    private List<CustomSpawner> f_8558_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void adastra$init(MinecraftServer server, Executor dispatcher, LevelStorageSource.LevelStorageAccess levelStorageAccess, ServerLevelData serverLevelData, ResourceKey<Level> dimension, LevelStem levelStem, ChunkProgressListener progressListener, boolean isDebug, long biomeZoomSeed, List<CustomSpawner> customSpawners, boolean tickTime, @Nullable RandomSequences randomSequences, CallbackInfo ci) {
        if (!PlanetApi.API.isPlanet(dimension)) {
            return;
        }
        this.f_8558_ = ImmutableList.builder().addAll(customSpawners).add((Object)new LunarianWanderingTraderSpawner(serverLevelData)).build();
    }

    @Inject(method={"tickChunk"}, at={@At(value="TAIL")})
    public void tickChunk(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        if (!OxygenApi.API.hasOxygen(chunk.m_62953_())) {
            Level level = chunk.m_62953_();
            level.m_46473_().m_6182_("adastra$spaceeffects");
            EnvironmentEffects.tickChunk((ServerLevel)level, chunk);
            level.m_46473_().m_7238_();
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setDayTime(J)V", shift=At.Shift.AFTER)})
    public void adastra$tick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        ServerLevel level = (ServerLevel)this;
        if (PlanetApi.API.isExtraterrestrial((Level)level) && !Level.f_46428_.equals(level.m_46472_())) {
            long time = level.m_6106_().m_6792_() + 24000L;
            level.m_7654_().m_129785_().forEach(l -> l.m_8615_(time - time % 24000L));
        }
    }
}

