/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.SolarPanelMenu;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.ExtractOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SolarPanelBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.PUSH, ConstantComponents.SIDE_CONFIG_ENERGY));

    public SolarPanelBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 1);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new SolarPanelMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new ExtractOnlyEnergyContainer(MachineConfig.deshTierEnergyCapacity, MachineConfig.deshTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public EnergyContainerMachineBlockEntity.ChargeSlotType getChargeSlotType() {
        return EnergyContainerMachineBlockEntity.ChargeSlotType.POWER_ITEM;
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        if (this.canFunction()) {
            this.distributeToChargeSlots();
            if (this.isDay()) {
                this.generateEnergy(PlanetApi.API.getSolarPower((Level)level));
            }
        }
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pushEnergyNearby(this, pos, this.getEnergyStorage().maxExtract(), sideConfig.get(0), filter);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[0];
    }

    public boolean isDay() {
        if (this.level().m_46468_() % 24000L > 12000L) {
            return false;
        }
        return this.level().m_45527_(this.m_58899_().m_7494_());
    }

    public void generateEnergy(long generationRate) {
        this.energyContainer.internalInsert(generationRate, false);
    }

    public void distributeToChargeSlots() {
        ItemStack stack = this.m_8020_(0);
        if (stack.m_41619_()) {
            return;
        }
        if (!EnergyContainer.holdsEnergy((ItemStack)stack)) {
            return;
        }
        ItemStackHolder holder = new ItemStackHolder(stack);
        EnergyApi.moveEnergy((BlockEntity)this, null, (ItemStackHolder)holder, (long)this.getEnergyStorage().maxExtract(), (boolean)false);
        if (holder.isDirty()) {
            this.m_6836_(0, holder.getStack());
        }
    }
}

