/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.worldgen.bald_cypress;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTrunkPlacers;

public class BaldCypressTrunkPlacer
extends TrunkPlacer {
    private static final Direction[] DIRS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    public static final Codec<BaldCypressTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BaldCypressTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BaldCypressTrunkPlacer::new));

    public BaldCypressTrunkPlacer(int height, int heightRandA, int heightRandB) {
        super(height, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)WetlandWhimsyTrunkPlacers.BALD_CYPRESS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        TrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        this.root(level, blockSetter, random, pos, config);
        for (int i = 0; i < height; ++i) {
            this.m_226187_(level, blockSetter, random, pos.m_6630_(i), config);
            if (i <= 2 || i >= height - 2 || i % 2 == 0) continue;
            for (int j = 0; j < 4; ++j) {
                if (!(Math.random() < (double)((float)i / (float)height) - 0.25)) continue;
                this.branch(level, blockSetter, random, pos.m_6630_(i), DIRS[j], config);
            }
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.m_6630_(height), 0, false));
    }

    public void branch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, Direction dir, TreeConfiguration config) {
        Function<BlockState, BlockState> fn = block -> (BlockState)block.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_());
        this.m_226175_(level, blockSetter, random, pos.m_121945_(dir), config, fn);
    }

    public void root(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        int rootPosX = random.m_216339_(-1, 1);
        int rootPosZ = random.m_216339_(-1, 1);
        TrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7918_(rootPosX, -1, rootPosZ), (TreeConfiguration)config);
        for (int i = 0; i < 2; ++i) {
            this.m_226187_(level, blockSetter, random, pos.m_7918_(rootPosX, i, rootPosZ), config);
        }
    }
}

