/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datapacks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.datapacks.Datapacks;

public record ScalableReward(ResourceKey<Item> input, int max_drops, List<Loot> rewards) {
    public static final Codec<ScalableReward> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256913_).fieldOf("input").forGetter(ScalableReward::input), (App)Codec.INT.fieldOf("max_drops").forGetter(ScalableReward::max_drops), (App)Loot.CODEC.listOf().fieldOf("rewards").forGetter(ScalableReward::rewards)).apply((Applicative)instance, ScalableReward::new));

    public record Loot(Integer weight, Integer maxStackSize, Either<ResourceLocation, List<ResourceLocation>> items, List<ResourceKey<Enchantment>> enchantments) {
        public static final Codec<Loot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("weight").forGetter(Loot::weight), (App)Codec.INT.optionalFieldOf("max_stack_size", (Object)64).forGetter(Loot::maxStackSize), (App)Codec.either((Codec)ResourceLocation.f_135803_, (Codec)ResourceLocation.f_135803_.listOf()).fieldOf("items").forGetter(Loot::items), (App)Codec.list((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256762_)).optionalFieldOf("enchantments", List.of()).forGetter(Loot::enchantments)).apply((Applicative)instance, Loot::new));

        public ItemStack getItem(ServerLevel level, int quality) {
            ResourceLocation rLoc;
            if (this.items().left().isPresent()) {
                rLoc = (ResourceLocation)this.items().left().get();
            } else {
                List list = (List)this.items().right().get();
                rLoc = (ResourceLocation)list.get(level.m_213780_().m_216339_(0, list.size()));
            }
            Optional item = BuiltInRegistries.f_257033_.m_6612_(rLoc);
            if (item.isEmpty()) {
                return new ItemStack((ItemLike)Items.f_41937_);
            }
            ItemStack stack = new ItemStack((ItemLike)item.get());
            this.growStack(level, stack, quality);
            return stack;
        }

        private void growStack(ServerLevel level, @Nonnull ItemStack stack, int quality) {
            RandomSource random = level.m_213780_();
            int size = Integer.min(this.maxStackSize, Integer.min(stack.m_41741_(), random.m_216339_(1, quality)));
            stack.m_41769_(size - 1);
            if (stack.m_41763_()) {
                stack.m_41721_(random.m_216339_(1, stack.m_41776_() - 1));
            }
            if (!stack.m_41792_() || random.m_188499_()) {
                return;
            }
            HolderLookup.RegistryLookup getter = level.m_9598_().m_255025_(Registries.f_256762_);
            block0: for (ResourceKey<Enchantment> e : this.enchantments) {
                if (random.m_188499_()) continue;
                Enchantment enchantment = (Enchantment)getter.m_255043_(e).get();
                int maxLevel = enchantment.m_6586_();
                int enchantmentLevel = maxLevel == 1 ? maxLevel : random.m_216339_(1, maxLevel);
                ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
                book.m_41663_(enchantment, enchantmentLevel);
                if (!stack.isBookEnchantable(book)) continue;
                for (Map.Entry otherEnchant : stack.getAllEnchantments().entrySet()) {
                    if (!enchantment.m_44695_((Enchantment)otherEnchant.getKey())) continue;
                    continue block0;
                }
                WetlandWhimsy.LOGGER.info("" + maxLevel);
                stack.m_41663_(enchantment, enchantmentLevel);
            }
        }
    }

    public class Manager {
        public static List<ItemStack> getLoot(ServerLevel level, ItemLike key, int quality) {
            RandomSource random = level.m_213780_();
            HolderLookup.RegistryLookup scalableRewardRegistries = level.m_7654_().m_206579_().m_255025_(Datapacks.SCALABLE_REWARD);
            HolderLookup.RegistryLookup itemRegistries = level.m_7654_().m_206579_().m_255025_(Registries.f_256913_);
            var wrapper = new Object(){
                ScalableReward scalableReward = null;
            };
            scalableRewardRegistries.m_214062_().forEach(registry -> {
                ScalableReward scalableReward = (ScalableReward)registry.m_203334_();
                if (((Holder.Reference)itemRegistries.m_254902_(scalableReward.input()).get()).get() == key.m_5456_()) {
                    WetlandWhimsy.LOGGER.info("ScalableReward " + registry.m_205785_().m_135782_() + " found");
                    wrapper.scalableReward = scalableReward;
                }
            });
            if (wrapper.scalableReward == null) {
                WetlandWhimsy.LOGGER.warn("No ScalableReward found");
                return List.of();
            }
            ArrayList<Loot> rewards = new ArrayList<Loot>(wrapper.scalableReward.rewards);
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            int maxWeight = 0;
            for (Loot reward : rewards) {
                maxWeight += reward.weight().intValue();
            }
            ++quality;
            for (int i = 0; i < Math.min(random.m_216339_(random.m_216339_(1, quality), quality), wrapper.scalableReward.max_drops); ++i) {
                list.add(Manager.getStack(level, rewards, quality, maxWeight));
            }
            return list;
        }

        private static ItemStack getStack(ServerLevel level, List<Loot> rewards, int quality, int maxWeight) {
            ArrayList<Loot> choices = new ArrayList<Loot>();
            block0: for (int i = 0; i < quality - 1; ++i) {
                int rand = level.m_213780_().m_216339_(0, maxWeight);
                int cursor = 0;
                for (Loot choice : rewards) {
                    if ((cursor += choice.weight().intValue()) < rand) continue;
                    choices.add(choice);
                    continue block0;
                }
            }
            int choiceWeight = Integer.MAX_VALUE;
            Loot toReturn = null;
            for (Loot choice : choices) {
                if (choice.weight() > choiceWeight) continue;
                choiceWeight = choice.weight();
                toReturn = choice;
            }
            rewards.remove(toReturn);
            return toReturn == null ? new ItemStack((ItemLike)Items.f_41937_) : toReturn.getItem(level, quality);
        }
    }
}

