/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.entities.goals;

import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;

public class LongJumpUtil {
    public static Optional<Vec3> calculateJumpVectorForAngle(Mob mob, Vec3 target, float maxJumpVelocity, int angle, boolean requireClearTransition) {
        Vec3 vec3 = mob.m_20182_();
        Vec3 vec31 = new Vec3(target.f_82479_ - vec3.f_82479_, 0.0, target.f_82481_ - vec3.f_82481_).m_82541_().m_82490_(0.5);
        Vec3 vec32 = target.m_82546_(vec31);
        Vec3 vec33 = vec32.m_82546_(vec3);
        float f = (float)angle * (float)Math.PI / 180.0f;
        double d0 = Math.atan2(vec33.f_82481_, vec33.f_82479_);
        double d1 = vec33.m_82492_(0.0, vec33.f_82480_, 0.0).m_82556_();
        double d2 = Math.sqrt(d1);
        double d3 = vec33.f_82480_;
        double d4 = 0.08;
        double d5 = Math.sin(2.0f * f);
        double d6 = Math.pow(Math.cos(f), 2.0);
        double d7 = Math.sin(f);
        double d8 = Math.cos(f);
        double d9 = Math.sin(d0);
        double d10 = Math.cos(d0);
        double d11 = d1 * d4 / (d2 * d5 - 2.0 * d3 * d6);
        if (d11 < 0.0) {
            return Optional.empty();
        }
        double d12 = Math.sqrt(d11);
        if (d12 > (double)maxJumpVelocity) {
            return Optional.empty();
        }
        double d13 = d12 * d8;
        double d14 = d12 * d7;
        if (requireClearTransition) {
            int i = Mth.m_14165_((double)(d2 / d13)) * 2;
            double d15 = 0.0;
            Vec3 vec34 = null;
            EntityDimensions entitydimensions = mob.m_6972_(Pose.LONG_JUMPING);
            for (int j = 0; j < i - 1; ++j) {
                double d16 = d7 / d8 * (d15 += d2 / (double)i) - Math.pow(d15, 2.0) * d4 / (2.0 * d11 * Math.pow(d8, 2.0));
                double d17 = d15 * d10;
                double d18 = d15 * d9;
                Vec3 vec35 = new Vec3(vec3.f_82479_ + d17, vec3.f_82480_ + d16, vec3.f_82481_ + d18);
                if (vec34 != null && !LongJumpUtil.isClearTransition(mob, entitydimensions, vec34, vec35)) {
                    return Optional.empty();
                }
                vec34 = vec35;
            }
        }
        return Optional.of(new Vec3(d13 * d10, d14, d13 * d9).m_82490_((double)0.95f));
    }

    private static boolean isClearTransition(Mob mob, EntityDimensions dimensions, Vec3 startPos, Vec3 endPos) {
        Vec3 vec3 = endPos.m_82546_(startPos);
        double d0 = Math.min(dimensions.f_20377_, dimensions.f_20378_);
        int i = Mth.m_14165_((double)(vec3.m_82553_() / d0));
        Vec3 vec31 = vec3.m_82541_();
        Vec3 vec32 = startPos;
        for (int j = 0; j < i; ++j) {
            Vec3 vec33 = vec32 = j == i - 1 ? endPos : vec32.m_82549_(vec31.m_82490_(d0 * (double)0.9f));
            if (mob.m_9236_().m_45756_((Entity)mob, dimensions.m_20393_(vec32))) continue;
            return false;
        }
        return true;
    }
}

