/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyParticleTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;
import uwu.juni.wetland_whimsy.content.blocks.entities.AncientPotBlockEntity;
import uwu.juni.wetland_whimsy.misc.WetlandWhimsyAdvancementTriggers;

@ParametersAreNonnullByDefault
public class AncientPotBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61372_;

    public AncientPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new AncientPotBlockEntity(pos, state);
    }

    public RenderShape m_7514_(@Nonnull BlockState a) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState a, BlockGetter b, BlockPos c, CollisionContext d) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.m_61124_(FACING, (Comparable)context.m_8125_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_((Item)WetlandWhimsyItems.ANCIENT_COIN.get())) {
            return InteractionResult.FAIL;
        }
        if (!player.m_7500_()) {
            stack.m_41764_(stack.m_41613_() - 1);
        }
        AncientPotBlockEntity entity = (AncientPotBlockEntity)((Object)level.m_141902_(pos, (BlockEntityType)WetlandWhimsyBlockEntities.ANCIENT_POT.get()).get());
        entity.increaseLootQuality();
        entity.m_6596_();
        level.m_142346_(null, GameEvent.f_157792_, pos);
        level.m_5594_(null, pos, (SoundEvent)WetlandWhimsySounds.ANCIENT_POT_INSERT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.dropLoot(level, pos);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AncientPotBlockEntity) {
                AncientPotBlockEntity ap = (AncientPotBlockEntity)blockEntity;
                WetlandWhimsyAdvancementTriggers.ANCIENT_POT_TRIGGER.trigger(sp, ap.lootQuality());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    private void dropLoot(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AncientPotBlockEntity blockEntity = (AncientPotBlockEntity)((Object)level.m_141902_(pos, (BlockEntityType)WetlandWhimsyBlockEntities.ANCIENT_POT.get()).get());
            blockEntity.dropLoot(serverLevel, pos);
            serverLevel.m_8767_((ParticleOptions)WetlandWhimsyParticleTypes.ANCIENT_SOULS.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Math.min(WetlandWhimsy.config.ancientPotMaxParticleCount, blockEntity.lootQuality() - 1), 0.2, 0.2, 0.2, 0.0);
        }
    }
}

