/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.crane;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.crane.CraneAnimations;
import uwu.juni.wetland_whimsy.content.entities.CraneEntity;

@ParametersAreNonnullByDefault
public class CraneModel
extends HierarchicalModel<CraneEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WetlandWhimsy.rLoc("crane"), "main");
    private final ModelPart crane;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart body;
    private final ModelPart left_wing;
    private final ModelPart evil;

    public CraneModel(ModelPart root) {
        this.crane = root.m_171324_("crane");
        this.neck = this.crane.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.left_leg = this.crane.m_171324_("left_leg");
        this.right_leg = this.crane.m_171324_("right_leg");
        this.body = this.crane.m_171324_("body");
        this.left_wing = this.body.m_171324_("left_wing");
        this.evil = this.body.m_171324_("evil");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition crane = partdefinition.m_171599_("crane", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition neck = crane.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-4.0f));
        PartDefinition cube_r1 = neck.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(44, 10).m_171488_(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(18, 46).m_171488_(0.0f, -2.0f, -6.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 40).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)1.0f));
        PartDefinition left_leg = crane.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition lower_r1 = left_leg.m_171599_("lower_r1", CubeListBuilder.m_171558_().m_171514_(26, 46).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)8.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition upper_r1 = left_leg.m_171599_("upper_r1", CubeListBuilder.m_171558_().m_171514_(38, 40).m_171488_(-2.0f, -6.0f, -1.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)3.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = crane.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition upper_r2 = right_leg.m_171599_("upper_r2", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(-2.0f, -6.0f, -1.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)3.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition lower_r2 = right_leg.m_171599_("lower_r2", CubeListBuilder.m_171558_().m_171514_(30, 46).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)8.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition body = crane.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 40).m_171488_(-2.0f, -9.0f, 8.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition body_r1 = body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -8.0f, -1.0f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-12.0f, (float)-5.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = body.m_171599_("left_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-18.0f, (float)-2.0f));
        PartDefinition cube_r2 = left_wing.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(0.0f, -0.6232f, -0.6995f, 1.0f, 6.0f, 12.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition evil = body.m_171599_("evil", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-18.0f, (float)-2.0f));
        PartDefinition cube_r3 = evil.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(26, 22).m_171488_(0.0f, -0.6232f, -0.6995f, 1.0f, 6.0f, 12.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@Nonnull CraneEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.crane.m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.m_267799_(CraneAnimations.WALK, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        this.m_233385_(entity.idleAnimationState, CraneAnimations.IDLE, ageInTicks, 1.0f);
        this.m_233385_(entity.flyAnimationState, CraneAnimations.FLY, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.m_14036_((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.crane;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.crane.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

